## Prerequisites

You need Python 3 including the 'pip' and 'venv' packages installed on your system. The instructions for these vary, refer to https://www.python.org/ for details.

For Linux distributions with apt, you can use

```
$ sudo apt update
$ sudo apt install python3-pip
$ sudo apt install python3-venv
```

## macOS and Linux, including Raspberry Pi OS

```
$ python3 -m venv venv
$ source venv/bin/activate
$ pip install -r requirements.txt
$ python3 RA_App_Demo_GUI.py
or
$ python3 RA_App_Demo_CLI.py <comport>
```

## Windows 10/11 (x86/x64/ARM64)

```
> python.exe -m venv venv
> .\venv\Scripts\activate
> pip.exe install -r .\requirements.txt
> python.exe .\RA_App_Demo_GUI.py
or
> python.exe .\RA_App_Demo_CLI.py <comport>
```

## Troubleshooting

### No matching distribution found for kivy_deps.sdl2_dev

If receiving this error during the installation of the requirements, you may have to do the following install before:

```
pip install kivy[base] kivy_examples --pre --extra-index-url https://kivy.org/downloads/simple/
```

### Kivy fatal error "GL: Minimum required OpenGL version (2.0) NOT found!"

Under Windows, if receiving this error when running RA_App_Demo_GUI.py, try installing the [OpenCL, OpenGL, and Vulkan Compatibility Pack](https://apps.microsoft.com/detail/9nqpsl29bfff) from the Microsoft store.